/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;

public class DecimalDataArea
extends DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int DEFAULT_LENGTH = 15;
    private BigDecimal initialValue_ = new BigDecimal("0.0");
    private int decimalPositions_ = 5;

    public DecimalDataArea() {
        this.length_ = 15;
        this.dataAreaType_ = 2;
    }

    public DecimalDataArea(AS400 system, String path) {
        super(system, path);
        this.length_ = 15;
        this.dataAreaType_ = 2;
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.clear();
        this.fireCleared();
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.create(this.length_, this.decimalPositions_, this.initialValue_, this.textDescription_, this.authority_);
        this.fireCreated();
    }

    public void create(int length, int decimalPositions, BigDecimal initialValue, String textDescription, String authority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (length < 1 || length > 24) {
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (decimalPositions < 0 || decimalPositions > 9) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 4);
        }
        if (decimalPositions > length) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 2);
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue");
        }
        if (textDescription == null) {
            throw new NullPointerException("textDescription");
        }
        if (textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (authority.length() == 0 || authority.length() > 10) {
            throw new ExtendedIllegalArgumentException("authority", 1);
        }
        this.length_ = length;
        this.decimalPositions_ = decimalPositions;
        this.initialValue_ = initialValue;
        this.textDescription_ = textDescription;
        this.authority_ = authority;
        this.create();
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.delete0();
    }

    public int getDecimalPositions() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getDecimalPositions();
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    public BigDecimal read() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        BigDecimal val = this.impl_.readBigDecimal();
        this.fireRead();
        return val;
    }

    @Override
    public void setPath(String path) throws PropertyVetoException {
        super.setPath(path);
    }

    public void write(BigDecimal data) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data);
        this.fireWritten();
    }
}

