/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsOutput;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsOutputData;

@Transform(id="GoogleSheetsOutput", image="google-sheets-output.svg", name="i18n::GoogleSheetsOutput.transform.Name", description="i18n::GoogleSheetsOutput.transform.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/google-sheets-output.html")
public class GoogleSheetsOutputMeta
extends BaseTransformMeta<GoogleSheetsOutput, GoogleSheetsOutputData> {
    @HopMetadataProperty(key="jsonCredentialPath", injectionGroupKey="SHEET")
    private String jsonCredentialPath;
    @HopMetadataProperty(key="spreadsheetKey", injectionGroupKey="SHEET")
    private String spreadsheetKey;
    @HopMetadataProperty(key="worksheetId", injectionGroupKey="SHEET")
    private String worksheetId;
    @HopMetadataProperty(key="SHAREEMAIL", injectionGroupKey="SHEET")
    private String shareEmail;
    @HopMetadataProperty(key="SHAREDOMAIN", injectionGroupKey="SHEET")
    private String shareDomain;
    @HopMetadataProperty(key="CREATE", injectionGroupKey="SHEET")
    private boolean create = true;
    @HopMetadataProperty(key="APPEND", injectionGroupKey="SHEET")
    private boolean append;
    @HopMetadataProperty(key="timeout", injectionGroupKey="SHEET")
    private String timeout;
    @HopMetadataProperty(key="impersonation", injectionGroupKey="SHEET")
    private String impersonation;
    @HopMetadataProperty(key="appName", injectionGroupKey="SHEET")
    private String appName;
    @HopMetadataProperty(key="replace_sheet", injectionGroupKey="SHEET")
    private boolean replaceSheet;
    @HopMetadataProperty
    private String proxyHost;
    @HopMetadataProperty
    private String proxyPort;

    public void setDefault() {
        this.jsonCredentialPath = "client_secret.json";
        this.spreadsheetKey = "";
        this.worksheetId = "";
        this.shareDomain = "";
        this.shareEmail = "";
        this.create = true;
        this.append = false;
        this.replaceSheet = false;
        this.impersonation = "";
        this.appName = "";
        this.timeout = "5";
    }

    public Object clone() {
        GoogleSheetsOutputMeta retval = (GoogleSheetsOutputMeta)((Object)super.clone());
        retval.setJsonCredentialPath(this.jsonCredentialPath);
        retval.setSpreadsheetKey(this.spreadsheetKey);
        retval.setWorksheetId(this.worksheetId);
        retval.setCreate(this.create);
        retval.setAppend(this.append);
        retval.setShareEmail(this.shareEmail);
        retval.setShareDomain(this.shareDomain);
        return retval;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metadataProvider) {
        if (prev == null || prev.isEmpty()) {
            remarks.add((ICheckResult)new CheckResult(1, "Not receiving any fields from previous transforms.", (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, String.format("Transform is connected to previous one, receiving %1$d fields", prev.size()), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(4, "Transform is receiving info from other transforms!", (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, "No input received from other transforms.", (ICheckResultSource)transformMeta));
        }
    }

    @Generated
    public String getJsonCredentialPath() {
        return this.jsonCredentialPath;
    }

    @Generated
    public String getSpreadsheetKey() {
        return this.spreadsheetKey;
    }

    @Generated
    public String getWorksheetId() {
        return this.worksheetId;
    }

    @Generated
    public String getShareEmail() {
        return this.shareEmail;
    }

    @Generated
    public String getShareDomain() {
        return this.shareDomain;
    }

    @Generated
    public boolean isCreate() {
        return this.create;
    }

    @Generated
    public boolean isAppend() {
        return this.append;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getImpersonation() {
        return this.impersonation;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public boolean isReplaceSheet() {
        return this.replaceSheet;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public String getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public void setJsonCredentialPath(String jsonCredentialPath) {
        this.jsonCredentialPath = jsonCredentialPath;
    }

    @Generated
    public void setSpreadsheetKey(String spreadsheetKey) {
        this.spreadsheetKey = spreadsheetKey;
    }

    @Generated
    public void setWorksheetId(String worksheetId) {
        this.worksheetId = worksheetId;
    }

    @Generated
    public void setShareEmail(String shareEmail) {
        this.shareEmail = shareEmail;
    }

    @Generated
    public void setShareDomain(String shareDomain) {
        this.shareDomain = shareDomain;
    }

    @Generated
    public void setCreate(boolean create) {
        this.create = create;
    }

    @Generated
    public void setAppend(boolean append) {
        this.append = append;
    }

    @Generated
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setImpersonation(String impersonation) {
        this.impersonation = impersonation;
    }

    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Generated
    public void setReplaceSheet(boolean replaceSheet) {
        this.replaceSheet = replaceSheet;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }
}

