/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.parser.PullParserException;
import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.wsdl.WsdlParseException;
import java.io.IOException;
import java.io.InputStream;

public class WsdlParser {
    private XmlInputStream in;

    public WsdlParser(XmlInputStream in) {
        this.in = in;
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws WsdlParseException {
        try {
            this.in.setInput(inputStream, inputEncoding);
        }
        catch (PullParserException e) {
            throw new WsdlParseException("Failed to set input", e);
        }
    }

    public String getNamespace(String prefix) {
        return this.in.getNamespace(prefix);
    }

    public String getPositionDescription() {
        return String.valueOf(this.in.getLineNumber()) + ":" + this.in.getColumnNumber();
    }

    public String getNamespace() {
        return this.in.getNamespace();
    }

    public String getName() {
        return this.in.getName();
    }

    public String getAttributeValue(String namespace, String name) {
        return this.in.getAttributeValue(namespace, name);
    }

    public int getEventType() throws WsdlParseException {
        try {
            return this.in.getEventType();
        }
        catch (ConnectionException e) {
            throw new WsdlParseException(e);
        }
    }

    public int next() throws WsdlParseException {
        try {
            return this.in.next();
        }
        catch (IOException e) {
            throw new WsdlParseException(e);
        }
        catch (ConnectionException e) {
            throw new WsdlParseException(e);
        }
    }

    public String toString() {
        return "WsdlParser: " + this.in.toString();
    }

    public String nextText() throws WsdlParseException {
        try {
            return this.in.nextText();
        }
        catch (IOException e) {
            throw new WsdlParseException(e);
        }
        catch (ConnectionException e) {
            throw new WsdlParseException(e);
        }
    }

    public int nextTag() throws WsdlParseException {
        try {
            return this.in.nextTag();
        }
        catch (IOException e) {
            throw new WsdlParseException(e);
        }
        catch (ConnectionException e) {
            throw new WsdlParseException(e);
        }
    }

    public int peekTag() throws WsdlParseException {
        try {
            return this.in.peekTag();
        }
        catch (ConnectionException e) {
            throw new WsdlParseException(e);
        }
        catch (IOException e) {
            throw new WsdlParseException(e);
        }
    }
}

