/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebServiceServlet;
import org.apache.hop.www.async.AsyncStatus;
import org.apache.hop.www.async.AsyncWebService;

@HopServerServlet(id="asyncStatus", name="Get the status of an asynchronously executing workflow")
public class AsyncStatusServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = WebServiceServlet.class;
    private static final long serialVersionUID = 2943295824369134751L;
    public static final String CONTEXT_PATH = "/hop/asyncStatus";

    public AsyncStatusServlet() {
    }

    public AsyncStatusServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String webServiceName;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"AsyncStatusServlet.Log.AsyncStatusRequested", (String[])new String[0]));
        }
        IVariables variables = this.pipelineMap.getHopServerConfig().getVariables();
        MultiMetadataProvider metadataProvider = new MultiMetadataProvider(Encr.getEncoder(), new ArrayList(), variables);
        metadataProvider.getProviders().add(HopMetadataUtil.getStandardHopMetadataProvider((IVariables)variables));
        String metadataFolder = this.pipelineMap.getHopServerConfig().getMetadataFolder();
        if (StringUtils.isNotEmpty((String)metadataFolder)) {
            metadataProvider.getProviders().add(new JsonMetadataProvider(Encr.getEncoder(), metadataFolder, variables));
        }
        if (StringUtils.isEmpty((String)(webServiceName = request.getParameter("service")))) {
            throw new ServletException("Please specify a service parameter pointing to the name of the asynchronous webservice object");
        }
        String serverObjectId = request.getParameter("id");
        if (StringUtils.isEmpty((String)serverObjectId)) {
            throw new ServletException("Please specify an id parameter pointing to the unique ID of the asynchronous webservice object");
        }
        try {
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(AsyncWebService.class);
            AsyncWebService webService = (AsyncWebService)serializer.load(webServiceName);
            if (webService == null) {
                throw new HopException("Unable to find asynchronous web service '" + webServiceName + "'.  You can set option metadata_folder in the Hop server XML configuration");
            }
            IWorkflowEngine workflow = this.workflowMap.findWorkflow(webServiceName, serverObjectId);
            AsyncStatus status = new AsyncStatus();
            status.setService(webServiceName);
            status.setId(serverObjectId);
            status.setStartDate(workflow.getExecutionStartDate());
            status.setEndDate(workflow.getExecutionEndDate());
            status.setStatusDescription(workflow.getStatusDescription());
            for (String statusVariable : webService.getStatusVariablesList(variables)) {
                String statusValue = workflow.getVariable(statusVariable);
                status.getStatusVariables().put(statusVariable, statusValue);
            }
            for (String dataValue : workflow.getExtensionDataMap().values()) {
                if (!(dataValue instanceof HopServerPipelineStatus)) continue;
                HopServerPipelineStatus hopServerPipelineStatus = (HopServerPipelineStatus)dataValue;
                status.getPipelineStatuses().add(hopServerPipelineStatus);
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            ServletOutputStream outputStream = response.getOutputStream();
            ObjectMapper mapper = HopJson.newMapper();
            String jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)status);
            byte[] data = jsonString.getBytes(StandardCharsets.UTF_8);
            response.setContentLength(data.length);
            outputStream.write(data);
            outputStream.flush();
            response.setStatus(200);
        }
        catch (Exception e) {
            throw new ServletException("Error getting asynchronous web service status", (Throwable)e);
        }
    }

    public String toString() {
        return "Asynchronous Web Service Status Servlet";
    }

    public String getService() {
        return "/hop/asyncStatus (" + this.toString() + ")";
    }

    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

