/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.annotation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.service.annotation.HttpExchange;

class HttpExchangeBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    HttpExchangeBeanRegistrationAotProcessor() {
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        ArrayList exchangeInterfaces = new ArrayList();
        MergedAnnotations.Search search = MergedAnnotations.search(MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        for (Class<?> interfaceClass : ClassUtils.getAllInterfacesForClass(beanClass)) {
            ReflectionUtils.doWithMethods(interfaceClass, method -> {
                if (!exchangeInterfaces.contains(interfaceClass) && search.from(method).isPresent(HttpExchange.class)) {
                    exchangeInterfaces.add(interfaceClass);
                }
            });
        }
        if (!exchangeInterfaces.isEmpty()) {
            return new AotContribution(exchangeInterfaces);
        }
        return null;
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final List<Class<?>> httpExchangeInterfaces;

        public AotContribution(List<Class<?>> httpExchangeInterfaces) {
            this.httpExchangeInterfaces = httpExchangeInterfaces;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ProxyHints proxyHints = generationContext.getRuntimeHints().proxies();
            for (Class<?> httpExchangeInterface : this.httpExchangeInterfaces) {
                proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces(httpExchangeInterface));
            }
        }
    }
}

