/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.assetPipeline;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.options.Options;
import org.grails.forge.template.URLTemplate;

@Singleton
public class AssetPipeline
implements DefaultFeature {
    private final CoordinateResolver coordinateResolver;

    public AssetPipeline(CoordinateResolver coordinateResolver) {
        this.coordinateResolver = coordinateResolver;
    }

    @Override
    @NonNull
    public String getName() {
        return "asset-pipeline-grails";
    }

    @Override
    public String getTitle() {
        return "Asset Pipeline";
    }

    @Override
    @NonNull
    public String getDescription() {
        return "Asset Pipeline is used for managing and processing static assets (such as JavaScript, CSS and image files) in Grails applications. Read more at https://github.com/wondrify/asset-pipeline.";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addBuildscriptDependency(Dependency.builder().groupId("cloud.wondrify").artifactId("asset-pipeline-gradle").buildSrc());
        generatorContext.addBuildPlugin(GradlePlugin.builder().id("cloud.wondrify.asset-pipeline").useApplyPlugin(true).build());
        generatorContext.addDependency(Dependency.builder().groupId("cloud.wondrify").artifactId("asset-pipeline-grails").runtimeOnly());
        generatorContext.addDependency(Dependency.builder().groupId("org.webjars.npm").artifactId("bootstrap").testAndDevelopmentOnly());
        generatorContext.addDependency(Dependency.builder().groupId("org.webjars.npm").artifactId("bootstrap-icons").testAndDevelopmentOnly());
        generatorContext.addDependency(Dependency.builder().groupId("org.webjars.npm").artifactId("jquery").testAndDevelopmentOnly());
        List<String> assetPaths = List.of("grails-app/assets/images/advancedgrails.svg", "grails-app/assets/images/community.svg", "grails-app/assets/images/documentation.svg", "grails-app/assets/images/favicon.ico", "grails-app/assets/images/grails.svg", "grails-app/assets/images/groovy.svg", "grails-app/assets/images/java.svg", "grails-app/assets/images/spring.svg", "grails-app/assets/images/spring-boot.svg", "grails-app/assets/javascripts/application.js", "grails-app/assets/javascripts/welcome.js", "grails-app/assets/stylesheets/application.css", "grails-app/assets/stylesheets/errors.css", "grails-app/assets/stylesheets/grails.css", "grails-app/assets/stylesheets/welcome.css");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String assetTemplate : assetPaths) {
            AssetPipeline.addAssetTemplate(generatorContext, classLoader, assetTemplate);
        }
    }

    private static void addAssetTemplate(GeneratorContext generatorContext, ClassLoader classLoader, String assetPath) {
        String fileName = assetPath.substring(assetPath.lastIndexOf(47) + 1);
        String templateKey = fileName.replaceFirst("\\.", "_");
        String resourcePath = assetPath.replaceFirst("^grails-app/", "");
        generatorContext.addTemplate(templateKey, new URLTemplate(assetPath, classLoader.getResource(resourcePath)));
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return applicationType == ApplicationType.WEB || applicationType == ApplicationType.WEB_PLUGIN;
    }

    @Override
    public String getCategory() {
        return "View Rendering";
    }

    @Override
    public String getDocumentation() {
        return "https://github.com/wondrify/asset-pipeline#readme";
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return applicationType != ApplicationType.REST_API && applicationType != ApplicationType.PLUGIN;
    }
}

