/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.mvc;

import grails.web.mvc.FlashScope;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.mvc.OutputAwareHttpServletResponse;
import org.grails.web.servlet.mvc.ParameterCreationListener;
import org.grails.web.util.WebUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class GrailsWebRequestFilter
extends OncePerRequestFilter
implements ApplicationContextAware {
    Collection<ParameterCreationListener> paramListenerBeans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        LocaleContextHolder.setLocale(request.getLocale());
        response = new OutputAwareHttpServletResponse((HttpServletResponse)response);
        boolean isIncludeOrForward = WebUtils.isForwardOrInclude(request);
        GrailsWebRequest previous = isIncludeOrForward ? GrailsWebRequest.lookup(request) : null;
        GrailsWebRequest webRequest = new GrailsWebRequest(request, (HttpServletResponse)response, this.getServletContext());
        this.configureParameterCreationListeners(webRequest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound Grails request context to thread: " + String.valueOf(request));
        }
        try {
            WebUtils.storeGrailsWebRequest(webRequest);
            if (!isIncludeOrForward) {
                FlashScope fs = webRequest.getAttributes().getFlashScope((ServletRequest)request);
                fs.next();
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            webRequest.requestCompleted();
            if (isIncludeOrForward) {
                if (previous != null) {
                    WebUtils.storeGrailsWebRequest(previous);
                }
            } else {
                WebUtils.clearGrailsWebRequest();
                LocaleContextHolder.setLocale(null);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Cleared Grails thread-bound request context: " + String.valueOf(request));
            }
        }
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    private void configureParameterCreationListeners(GrailsWebRequest webRequest) {
        if (this.paramListenerBeans != null) {
            for (ParameterCreationListener creationListenerBean : this.paramListenerBeans) {
                webRequest.addParameterListener(creationListenerBean);
            }
        } else {
            this.logger.warn("paramListenerBeans isn't initialized.");
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.paramListenerBeans = applicationContext.getBeansOfType(ParameterCreationListener.class).values();
    }
}

