/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.context;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.agents.api.context.MemoryObject;
import org.apache.flink.agents.api.context.RunnerContext;

public final class MemoryRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;

    private MemoryRef(String path) {
        this.path = path;
    }

    public static MemoryRef create(String path) {
        return new MemoryRef(path);
    }

    public MemoryObject resolve(RunnerContext ctx) throws Exception {
        return ctx.getShortTermMemory().get(this);
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryRef memoryRef = (MemoryRef)o;
        return this.path.equals(memoryRef.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return "MemoryRef{path='" + this.path + "'}";
    }
}

