/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.ArrayOfUtf16StringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.FrequentItemsSketch;
import org.apache.datasketches.frequencies.ReversePurgeItemHashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ItemsSketchTest {
    @Test
    public void empty() {
        FrequentItemsSketch sketch = new FrequentItemsSketch(8);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
        Assert.assertEquals((long)sketch.getStreamLength(), (long)0L);
        Assert.assertEquals((long)sketch.getLowerBound((Object)"a"), (long)0L);
        Assert.assertEquals((long)sketch.getUpperBound((Object)"a"), (long)0L);
    }

    @Test
    public void nullInput() {
        FrequentItemsSketch sketch = new FrequentItemsSketch(8);
        sketch.update(null);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
        Assert.assertEquals((long)sketch.getStreamLength(), (long)0L);
        Assert.assertEquals((long)sketch.getLowerBound(null), (long)0L);
        Assert.assertEquals((long)sketch.getUpperBound(null), (long)0L);
    }

    @Test
    public void oneItem() {
        FrequentItemsSketch sketch = new FrequentItemsSketch(8);
        sketch.update((Object)"a");
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)1);
        Assert.assertEquals((long)sketch.getStreamLength(), (long)1L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"a"), (long)1L);
        Assert.assertEquals((long)sketch.getLowerBound((Object)"a"), (long)1L);
    }

    @Test
    public void severalItems() {
        FrequentItemsSketch sketch = new FrequentItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        sketch.update((Object)"d");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        sketch.update((Object)"b");
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"a"), (long)1L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"b"), (long)3L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"c"), (long)2L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"d"), (long)1L);
        FrequentItemsSketch.Row[] items = sketch.getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
        Assert.assertEquals((int)items.length, (int)4);
        items = sketch.getFrequentItems(3L, ErrorType.NO_FALSE_POSITIVES);
        Assert.assertEquals((int)items.length, (int)1);
        Assert.assertEquals((String)((String)items[0].getItem()), (String)"b");
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
        Assert.assertEquals((long)sketch.getStreamLength(), (long)0L);
    }

    @Test
    public void estimationMode() {
        FrequentItemsSketch sketch = new FrequentItemsSketch(8);
        sketch.update((Object)1, 10L);
        sketch.update((Object)2);
        sketch.update((Object)3);
        sketch.update((Object)4);
        sketch.update((Object)5);
        sketch.update((Object)6);
        sketch.update((Object)7, 15L);
        sketch.update((Object)8);
        sketch.update((Object)9);
        sketch.update((Object)10);
        sketch.update((Object)11);
        sketch.update((Object)12);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getStreamLength(), (long)35L);
        FrequentItemsSketch.Row[] items = sketch.getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
        Assert.assertEquals((int)items.length, (int)2);
        int count = 0;
        for (FrequentItemsSketch.Row item : items) {
            if (item.getLowerBound() <= 1L) continue;
            ++count;
        }
        Assert.assertEquals((int)count, (int)2);
        items = sketch.getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
        Assert.assertTrue((items.length >= 2 ? 1 : 0) != 0);
        count = 0;
        for (FrequentItemsSketch.Row item : items) {
            if (item.getLowerBound() <= 5L) continue;
            ++count;
        }
        Assert.assertEquals((int)count, (int)2);
    }

    @Test
    public void serializeStringDeserializeEmpty() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(8);
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        FrequentItemsSketch sketch2 = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)0);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)0L);
    }

    @Test
    public void serializeDeserializeUft8Strings() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(8);
        sketch1.update((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
        sketch1.update((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
        sketch1.update((Object)"ccccccccccccccccccccccccccccc");
        sketch1.update((Object)"ddddddddddddddddddddddddddddd");
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        FrequentItemsSketch sketch2 = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        sketch2.update((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
        sketch2.update((Object)"ccccccccccccccccccccccccccccc");
        sketch2.update((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb"), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"ccccccccccccccccccccccccccccc"), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"ddddddddddddddddddddddddddddd"), (long)1L);
    }

    @Test
    public void serializeDeserializeUtf16Strings() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(8);
        sketch1.update((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
        sketch1.update((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
        sketch1.update((Object)"ccccccccccccccccccccccccccccc");
        sketch1.update((Object)"ddddddddddddddddddddddddddddd");
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)new ArrayOfUtf16StringsSerDe());
        FrequentItemsSketch sketch2 = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfUtf16StringsSerDe());
        sketch2.update((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
        sketch2.update((Object)"ccccccccccccccccccccccccccccc");
        sketch2.update((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"bbbbbbbbbbbbbbbbbbbbbbbbbbbbb"), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"ccccccccccccccccccccccccccccc"), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"ddddddddddddddddddddddddddddd"), (long)1L);
    }

    @Test
    public void forceResize() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(16);
        for (int i = 0; i < 32; ++i) {
            sketch1.update((Object)Integer.toString(i), (long)(i * i));
        }
    }

    @Test
    public void getRowHeader() {
        String header = FrequentItemsSketch.Row.getRowHeader();
        Assert.assertNotNull((Object)header);
        Assert.assertTrue((header.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void serializeLongDeserialize() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(8);
        sketch1.update((Object)1L);
        sketch1.update((Object)2L);
        sketch1.update((Object)3L);
        sketch1.update((Object)4L);
        String s = sketch1.toString();
        ItemsSketchTest.println(s);
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        FrequentItemsSketch sketch2 = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        sketch2.update((Object)2L);
        sketch2.update((Object)3L);
        sketch2.update((Object)2L);
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)1L), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)2L), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)3L), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)4L), (long)1L);
    }

    @Test
    public void mergeExact() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(8);
        sketch1.update((Object)"a");
        sketch1.update((Object)"b");
        sketch1.update((Object)"c");
        sketch1.update((Object)"d");
        FrequentItemsSketch sketch2 = new FrequentItemsSketch(8);
        sketch2.update((Object)"b");
        sketch2.update((Object)"c");
        sketch2.update((Object)"b");
        sketch1.merge(sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((int)sketch1.getNumActiveItems(), (int)4);
        Assert.assertEquals((long)sketch1.getStreamLength(), (long)7L);
        Assert.assertEquals((long)sketch1.getEstimate((Object)"a"), (long)1L);
        Assert.assertEquals((long)sketch1.getEstimate((Object)"b"), (long)3L);
        Assert.assertEquals((long)sketch1.getEstimate((Object)"c"), (long)2L);
        Assert.assertEquals((long)sketch1.getEstimate((Object)"d"), (long)1L);
    }

    @Test
    public void checkNullMapReturns() {
        ReversePurgeItemHashMap map = new ReversePurgeItemHashMap(8);
        Assert.assertNull((Object)map.getActiveKeys());
        Assert.assertNull((Object)map.getActiveValues());
    }

    @Test
    public void checkMisc() {
        FrequentItemsSketch sk1 = new FrequentItemsSketch(8);
        Assert.assertEquals((int)sk1.getCurrentMapCapacity(), (int)6);
        Assert.assertEquals((long)sk1.getEstimate((Object)1L), (long)0L);
        FrequentItemsSketch sk2 = new FrequentItemsSketch(8);
        Assert.assertEquals((Object)sk1.merge(sk2), (Object)sk1);
        Assert.assertEquals((Object)sk1.merge(null), (Object)sk1);
        sk1.update((Object)1L);
        FrequentItemsSketch.Row[] rows = sk1.getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
        FrequentItemsSketch.Row row = rows[0];
        Assert.assertTrue((row.hashCode() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)row.equals((Object)row));
        Assert.assertFalse((boolean)row.equals((Object)sk1));
        Assert.assertEquals((long)((Long)row.getItem()), (long)1L);
        Assert.assertEquals((long)row.getEstimate(), (long)1L);
        Assert.assertEquals((long)row.getUpperBound(), (long)1L);
        String s = row.toString();
        ItemsSketchTest.println(s);
        Object nullRow = null;
        Assert.assertFalse((boolean)row.equals(nullRow));
    }

    @Test
    public void checkToString() {
        FrequentItemsSketch sk = new FrequentItemsSketch(8);
        sk.update((Object)1L);
        ItemsSketchTest.println(FrequentItemsSketch.toString((byte[])sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe())));
    }

    @Test
    public void checkGetFrequentItems1() {
        FrequentItemsSketch fis = new FrequentItemsSketch(8);
        fis.update((Object)1L);
        FrequentItemsSketch.Row[] rowArr = fis.getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
        FrequentItemsSketch.Row row = rowArr[0];
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)row.est, (long)1L);
        Assert.assertEquals((Long)((Long)row.item), (Long)1L);
        Assert.assertEquals((long)row.lb, (long)1L);
        Assert.assertEquals((long)row.ub, (long)1L);
        FrequentItemsSketch.Row newRow = new FrequentItemsSketch.Row((Object)((Long)row.item), row.est + 1L, row.ub, row.lb);
        Assert.assertFalse((boolean)row.equals((Object)newRow));
        newRow = new FrequentItemsSketch.Row((Object)((Long)row.item), row.est, row.ub, row.lb);
        Assert.assertTrue((boolean)row.equals((Object)newRow));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkUpdateException() {
        FrequentItemsSketch sk1 = new FrequentItemsSketch(8);
        sk1.update((Object)1L, -1L);
    }

    @Test
    public void checkMemorySegmentExceptions() {
        FrequentItemsSketch sk1 = new FrequentItemsSketch(8);
        sk1.update((Object)1L, 1L);
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] byteArr = sk1.toByteArray((ArrayOfItemsSerDe)serDe);
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        long pre0 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 0L);
        ItemsSketchTest.tryBadSeg(seg, 0, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        ItemsSketchTest.tryBadSeg(seg, 1, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        ItemsSketchTest.tryBadSeg(seg, 2, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        ItemsSketchTest.tryBadSeg(seg, 5, 4);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
    }

    @Test
    public void oneItemUtf8() {
        FrequentItemsSketch sketch1 = new FrequentItemsSketch(8);
        sketch1.update((Object)"\u5fb5");
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((int)sketch1.getNumActiveItems(), (int)1);
        Assert.assertEquals((long)sketch1.getStreamLength(), (long)1L);
        Assert.assertEquals((long)sketch1.getEstimate((Object)"\u5fb5"), (long)1L);
        byte[] bytes = sketch1.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        FrequentItemsSketch sketch2 = FrequentItemsSketch.getInstance((MemorySegment)MemorySegment.ofArray(bytes), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)1);
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)1L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"\u5fb5"), (long)1L);
    }

    @Test
    public void checkGetEpsilon() {
        Assert.assertEquals((double)FrequentItemsSketch.getEpsilon((int)1024), (double)0.00341796875, (double)0.0);
        try {
            FrequentItemsSketch.getEpsilon((int)1000);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkGetAprioriError() {
        double eps = 0.00341796875;
        Assert.assertEquals((double)FrequentItemsSketch.getAprioriError((int)1024, (long)10000L), (double)34.1796875);
    }

    @Test
    public void printlnTest() {
        ItemsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    private static void tryBadSeg(MemorySegment seg, int byteOffset, int byteValue) {
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        try {
            seg.set(ValueLayout.JAVA_BYTE, (long)byteOffset, (byte)byteValue);
            FrequentItemsSketch.getInstance((MemorySegment)seg, (ArrayOfItemsSerDe)serDe);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    static void println(String s) {
    }
}

