/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.parsers.ByteChunkWriter;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.apache.daffodil.runtime1.processors.parsers.PrimParser;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public abstract class HexBinaryLengthParser
implements ToBriefXMLImpl,
Processor,
PrimProcessor,
Parser,
PrimParser,
ByteChunkWriter {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(HexBinaryLengthParser.class.getDeclaredField("parserName$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HexBinaryLengthParser.class.getDeclaredField("org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1"));
    private volatile Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
    private boolean isInitialized;
    private volatile Object parserName$lzy1;
    private final ElementRuntimeData context;
    private final byte[] zeroLengthArray;

    public HexBinaryLengthParser(ElementRuntimeData context) {
        this.context = context;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        Parser.$init$(this);
        this.zeroLengthArray = new byte[0];
    }

    @Override
    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        Object object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1();
    }

    private Object org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    @Override
    public String parserName() {
        Object object = this.parserName$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.parserName$lzyINIT1();
    }

    private Object parserName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parserName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Parser.parserName$(this);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parserName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public ElementRuntimeData context() {
        return this.context;
    }

    public abstract long getLengthInBits(PState var1);

    @Override
    public final void parse(PState start) {
        DISimple currentElement = start.simpleElement();
        long nBits = this.getLengthInBits(start);
        long nBytes = (nBits + 7L) / 8L;
        if (nBytes == 0L) {
            currentElement.setDataValue(DataValue$.MODULE$.toDataValue(this.zeroLengthArray));
            return;
        }
        if (nBytes > (long)start.tunable().maxHexBinaryLengthInBytes()) {
            this.PE(start, "Length for xs:hexBinary exceeds maximum of %s bytes: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)start.tunable().maxHexBinaryLengthInBytes()), BoxesRunTime.boxToLong((long)nBytes)}));
            return;
        }
        if (nBytes <= (long)start.tunable().blobChunkSizeInBytes()) {
            InputSourceDataInputStream dis = start.dataInputStream();
            if (!dis.isDefinedForLength(nBits)) {
                this.PENotEnoughBits(start, nBits, dis);
                return;
            }
            byte[] array = start.dataInputStream().getByteArray((int)nBits, start);
            currentElement.setDataValue(DataValue$.MODULE$.toDataValue(array));
            return;
        }
        byte[] array = new byte[(int)nBytes];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        this.writeBitsInChunks(start, nBits, (Function2 & Serializable)(v1, v2) -> {
            HexBinaryLengthParser.parse$$anonfun$1(buffer, (byte[])v1, BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
        if (start.isSuccess()) {
            currentElement.setDataValue(DataValue$.MODULE$.toDataValue(array));
            return;
        }
    }

    private static final /* synthetic */ void parse$$anonfun$1(ByteBuffer buffer$1, byte[] x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            byte[] bytes = (byte[])tuple2._1();
            int nBytes = BoxesRunTime.unboxToInt((Object)tuple2._2());
            buffer$1.put(bytes, 0, nBytes);
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

