/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Protocol;
import org.apache.avro.grpc.AvroGrpcUtils;
import org.apache.avro.grpc.ServiceDescriptor;

public abstract class AvroGrpcServer {
    private AvroGrpcServer() {
    }

    public static ServerServiceDefinition createServiceDefinition(Class iface, Object impl) {
        Protocol protocol = AvroGrpcUtils.getProtocol(iface);
        ServiceDescriptor serviceDescriptor = ServiceDescriptor.create(iface);
        ServerServiceDefinition.Builder serviceDefinitionBuilder = ServerServiceDefinition.builder((String)serviceDescriptor.getServiceName());
        Map messages = protocol.getMessages();
        for (Method method : iface.getMethods()) {
            Protocol.Message msg = (Protocol.Message)messages.get(method.getName());
            if (msg == null) continue;
            UnaryMethodHandler methodHandler = msg.isOneWay() ? new OneWayUnaryMethodHandler(impl, method) : new UnaryMethodHandler(impl, method);
            serviceDefinitionBuilder.addMethod(serviceDescriptor.getMethod(method.getName(), MethodDescriptor.MethodType.UNARY), ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)methodHandler));
        }
        return serviceDefinitionBuilder.build();
    }

    private static class OneWayUnaryMethodHandler
    extends UnaryMethodHandler {
        private static final Logger LOG = Logger.getLogger(OneWayUnaryMethodHandler.class.getName());

        OneWayUnaryMethodHandler(Object serviceImpl, Method method) {
            super(serviceImpl, method);
        }

        @Override
        public void invoke(Object[] request, StreamObserver<Object> responseObserver) {
            responseObserver.onNext(null);
            responseObserver.onCompleted();
            try {
                this.getMethod().invoke(this.getServiceImpl(), request);
            }
            catch (Exception e) {
                Throwable cause;
                for (cause = e; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                }
                LOG.log(Level.WARNING, "Error processing one-way rpc", cause);
            }
        }
    }

    private static class UnaryMethodHandler
    implements ServerCalls.UnaryMethod<Object[], Object> {
        private final Object serviceImpl;
        private final Method method;

        UnaryMethodHandler(Object serviceImpl, Method method) {
            this.serviceImpl = serviceImpl;
            this.method = method;
        }

        public void invoke(Object[] request, StreamObserver<Object> responseObserver) {
            Object methodResponse = null;
            try {
                methodResponse = this.method.invoke(this.getServiceImpl(), request);
            }
            catch (InvocationTargetException e) {
                methodResponse = e.getTargetException();
            }
            catch (Exception e) {
                methodResponse = e;
            }
            responseObserver.onNext(methodResponse);
            responseObserver.onCompleted();
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getServiceImpl() {
            return this.serviceImpl;
        }
    }
}

