/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.IsResolvedSchemaVisitor;
import org.apache.avro.compiler.idl.ResolvingVisitor;
import org.apache.avro.compiler.schema.Schemas;

final class SchemaResolver {
    private static final String UR_SCHEMA_ATTR = "org.apache.avro.compiler.idl.unresolved.name";
    private static final String UR_SCHEMA_NAME = "UnresolvedSchema";
    private static final String UR_SCHEMA_NS = "org.apache.avro.compiler";

    private SchemaResolver() {
    }

    static Schema unresolvedSchema(String name) {
        Schema schema = Schema.createRecord(UR_SCHEMA_NAME, "unresolved schema", UR_SCHEMA_NS, false, Collections.EMPTY_LIST);
        schema.addProp(UR_SCHEMA_ATTR, name);
        return schema;
    }

    static boolean isUnresolvedSchema(Schema schema) {
        return schema.getType() == Schema.Type.RECORD && schema.getProp(UR_SCHEMA_ATTR) != null && UR_SCHEMA_NAME.equals(schema.getName()) && UR_SCHEMA_NS.equals(schema.getNamespace());
    }

    static String getUnresolvedSchemaName(Schema schema) {
        if (!SchemaResolver.isUnresolvedSchema(schema)) {
            throw new IllegalArgumentException("Not a unresolved schema: " + schema);
        }
        return schema.getProp(UR_SCHEMA_ATTR);
    }

    static boolean isFullyResolvedSchema(Schema schema) {
        if (SchemaResolver.isUnresolvedSchema(schema)) {
            return false;
        }
        return Schemas.visit(schema, new IsResolvedSchemaVisitor());
    }

    static Protocol resolve(Protocol protocol) {
        Protocol result = new Protocol(protocol.getName(), protocol.getDoc(), protocol.getNamespace());
        Collection<Schema> types = protocol.getTypes();
        ArrayList<Schema> newSchemas = new ArrayList<Schema>(types.size());
        IdentityHashMap<Schema, Schema> replacements = new IdentityHashMap<Schema, Schema>();
        for (Schema schema : types) {
            newSchemas.add(Schemas.visit(schema, new ResolvingVisitor(schema, replacements, new SymbolTable(protocol))));
        }
        result.setTypes(newSchemas);
        for (Map.Entry entry : protocol.getMessages().entrySet()) {
            Protocol.Message nvalue;
            Protocol.Message value = (Protocol.Message)entry.getValue();
            if (value.isOneWay()) {
                Schema replacement = SchemaResolver.resolve(replacements, value.getRequest(), protocol);
                nvalue = result.createMessage(value.getName(), value.getDoc(), value, replacement);
            } else {
                Schema request = SchemaResolver.resolve(replacements, value.getRequest(), protocol);
                Schema response = SchemaResolver.resolve(replacements, value.getResponse(), protocol);
                Schema errors = SchemaResolver.resolve(replacements, value.getErrors(), protocol);
                nvalue = result.createMessage(value.getName(), value.getDoc(), value, request, response, errors);
            }
            result.getMessages().put((String)entry.getKey(), nvalue);
        }
        Schemas.copyProperties(protocol, result);
        return result;
    }

    private static Schema resolve(IdentityHashMap<Schema, Schema> replacements, Schema request, Protocol protocol) {
        Schema replacement = replacements.get(request);
        if (replacement == null) {
            replacement = Schemas.visit(request, new ResolvingVisitor(request, replacements, new SymbolTable(protocol)));
        }
        return replacement;
    }

    private static class SymbolTable
    implements Function<String, Schema> {
        private final Protocol symbolTable;

        public SymbolTable(Protocol symbolTable) {
            this.symbolTable = symbolTable;
        }

        @Override
        public Schema apply(String f) {
            return this.symbolTable.getType(f);
        }
    }
}

