/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.xml;

import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.DBOption;
import org.apache.activemq.artemis.cli.commands.tools.xml.XMLMessageExporter;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.AckDescribe;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.CursorAckRecordEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageUpdateTXEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentAddressBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentQueueBindingEncoding;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="exp", description={"Export all message-data using an XML that could be interpreted by any system."})
public final class XmlDataExporter
extends DBOption {
    @CommandLine.Option(names={"log-interval"}, description={"How often to print progress in the console. Set to <= 0 to disable it."})
    private int logInterval = 10000;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private XMLStreamWriter xmlWriter;
    private Throwable lastError;
    @CommandLine.Option(names={"undefined-prefix"}, description={"In case a queue does not exist, this will define the prefix to be used on the message export. Default: 'UndefinedQueue_'"})
    private String undefinedPrefix = "UndefinedQueue_";
    private final Map<Long, Map<Long, DescribeJournal.ReferenceDescribe>> messageRefs = new HashMap<Long, Map<Long, DescribeJournal.ReferenceDescribe>>();
    private final Map<Long, Message> messages = new TreeMap<Long, Message>();
    private final Map<Long, Set<PagePosition>> cursorRecords = new HashMap<Long, Set<PagePosition>>();
    private final Set<Long> pgTXs = new HashSet<Long>();
    private final Map<Long, PersistentQueueBindingEncoding> queueBindings = new HashMap<Long, PersistentQueueBindingEncoding>();
    private final Map<Long, PersistentAddressBindingEncoding> addressBindings = new HashMap<Long, PersistentAddressBindingEncoding>();
    long messagesPrinted = 0L;
    long bindingsPrinted = 0L;
    XMLMessageExporter exporter;

    public String getUndefinedPrefix() {
        return this.undefinedPrefix;
    }

    public XmlDataExporter setUndefinedPrefix(String undefinedPrefix) {
        this.undefinedPrefix = undefinedPrefix;
        return this;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            this.config = this.getParameterConfiguration();
            this.process(context.out);
            this.done();
        }
        catch (Exception e) {
            this.treatError(e, "data", "exp");
        }
        return null;
    }

    @Deprecated
    public void process(OutputStream out, String bindingsDir, String journalDir, String pagingDir, String largeMessagesDir) throws Exception {
        this.config = new ConfigurationImpl().setBindingsDirectory(bindingsDir).setJournalDirectory(journalDir).setPagingDirectory(pagingDir).setLargeMessagesDirectory(largeMessagesDir).setJournalType(JournalType.NIO);
        this.initializeJournal(this.config);
        this.writeOutput(out);
        this.cleanup();
    }

    public void process(OutputStream out) throws Exception {
        this.initializeJournal(this.config);
        this.writeOutput(out);
        this.cleanup();
    }

    protected void writeOutput(OutputStream out) throws Exception {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter rawXmlWriter = factory.createXMLStreamWriter(out, "UTF-8");
        PrettyPrintHandler handler = new PrettyPrintHandler(rawXmlWriter);
        this.xmlWriter = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        this.exporter = new XMLMessageExporter(this.xmlWriter);
        this.writeXMLData();
    }

    private void writeXMLData() throws Exception {
        long start = System.currentTimeMillis();
        this.getBindings();
        this.processMessageJournal();
        this.printDataAsXML();
        logger.debug("\n\nProcessing took: {}ms", (Object)(System.currentTimeMillis() - start));
        logger.debug("Output {} messages and {} bindings.", (Object)this.messagesPrinted, (Object)this.bindingsPrinted);
    }

    private void processMessageJournal() throws Exception {
        ArrayList<RecordInfo> acks = new ArrayList<RecordInfo>();
        java.util.LinkedList records = new java.util.LinkedList();
        java.util.LinkedList preparedTransactions = new java.util.LinkedList();
        Journal messageJournal = this.storageManager.getMessageJournal();
        logger.debug("Reading journal from {}", (Object)this.config.getJournalDirectory());
        messageJournal.start();
        TransactionFailureCallback transactionFailureCallback = (transactionID, records1, recordsToDelete) -> {
            int i;
            StringBuilder message = new StringBuilder();
            message.append("Encountered failed journal transaction: ").append(transactionID);
            for (i = 0; i < records1.size(); ++i) {
                if (i == 0) {
                    message.append("; Records: ");
                }
                message.append(records1.get(i));
                if (i == records1.size() - 1) continue;
                message.append(", ");
            }
            for (i = 0; i < recordsToDelete.size(); ++i) {
                if (i == 0) {
                    message.append("; RecordsToDelete: ");
                }
                message.append(recordsToDelete.get(i));
                if (i == recordsToDelete.size() - 1) continue;
                message.append(", ");
            }
            logger.debug(message.toString());
        };
        messageJournal.load(records, preparedTransactions, transactionFailureCallback, false);
        preparedTransactions = null;
        for (RecordInfo info : records) {
            byte[] data = info.data;
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
            Object o = DescribeJournal.newObjectEncoding((RecordInfo)info, (JournalStorageManager)this.storageManager);
            if (info.getUserRecordType() == 31) {
                this.messages.put(info.id, (Message)((DescribeJournal.MessageDescribe)o).getMsg().toCore());
                continue;
            }
            if (info.getUserRecordType() == 45) {
                this.messages.put(info.id, (Message)((DescribeJournal.MessageDescribe)o).getMsg().toCore());
                continue;
            }
            if (info.getUserRecordType() == 30) {
                this.messages.put(info.id, ((DescribeJournal.MessageDescribe)o).getMsg());
                continue;
            }
            if (info.getUserRecordType() == 32) {
                DescribeJournal.ReferenceDescribe ref = (DescribeJournal.ReferenceDescribe)o;
                Map<Long, DescribeJournal.ReferenceDescribe> map = this.messageRefs.get(info.id);
                if (map == null) {
                    HashMap<Long, DescribeJournal.ReferenceDescribe> newMap = new HashMap<Long, DescribeJournal.ReferenceDescribe>();
                    newMap.put(ref.refEncoding.queueID, ref);
                    this.messageRefs.put(info.id, newMap);
                    continue;
                }
                map.put(ref.refEncoding.queueID, ref);
                continue;
            }
            if (info.getUserRecordType() == 33) {
                acks.add(info);
                continue;
            }
            if (info.userRecordType == 39) {
                CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                encoding.decode(buff);
                Set<PagePosition> set = this.cursorRecords.get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    this.cursorRecords.put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (info.userRecordType != 35) continue;
            if (info.isUpdate) {
                PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                this.pgTXs.add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(info.id);
            this.pgTXs.add(pageTransactionInfo.getTransactionID());
        }
        messageJournal.stop();
        this.removeAcked(acks);
    }

    private void removeAcked(List<RecordInfo> acks) {
        for (RecordInfo info : acks) {
            AckDescribe ack = (AckDescribe)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
            Map<Long, DescribeJournal.ReferenceDescribe> referenceDescribeHashMap = this.messageRefs.get(info.id);
            if (referenceDescribeHashMap == null) continue;
            referenceDescribeHashMap.remove(ack.refEncoding.queueID);
            if (!referenceDescribeHashMap.isEmpty()) continue;
            this.messages.remove(info.id);
            this.messageRefs.remove(info.id);
        }
    }

    private void getBindings() throws Exception {
        java.util.LinkedList records = new java.util.LinkedList();
        Journal bindingsJournal = this.storageManager.getBindingsJournal();
        bindingsJournal.start();
        logger.debug("Reading bindings journal from {}", (Object)this.config.getBindingsDirectory());
        bindingsJournal.load(records, null, null);
        for (RecordInfo info : records) {
            PersistentQueueBindingEncoding bindingEncoding;
            if (info.getUserRecordType() == 21) {
                bindingEncoding = (PersistentQueueBindingEncoding)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
                this.queueBindings.put(bindingEncoding.getQueueConfiguration().getId(), bindingEncoding);
                continue;
            }
            if (info.getUserRecordType() != 44) continue;
            bindingEncoding = (PersistentAddressBindingEncoding)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
            this.addressBindings.put(bindingEncoding.getId(), (PersistentAddressBindingEncoding)bindingEncoding);
        }
        bindingsJournal.stop();
    }

    private void printDataAsXML() {
        try {
            this.xmlWriter.writeStartElement("activemq-journal");
            this.printBindingsAsXML();
            this.printAllMessagesAsXML();
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
            this.xmlWriter.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.lastError = e;
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    private void printBindingsAsXML() throws XMLStreamException {
        this.xmlWriter.writeStartElement("bindings");
        for (Map.Entry<Long, PersistentAddressBindingEncoding> entry : this.addressBindings.entrySet()) {
            PersistentAddressBindingEncoding bindingEncoding = this.addressBindings.get(entry.getKey());
            this.xmlWriter.writeEmptyElement("address-binding");
            String routingTypes = bindingEncoding.getRoutingTypes().stream().map(Enum::toString).collect(Collectors.joining(","));
            this.xmlWriter.writeAttribute("routing-types", routingTypes);
            this.xmlWriter.writeAttribute("name", bindingEncoding.getName().toString());
            this.xmlWriter.writeAttribute("id", Long.toString(bindingEncoding.getId()));
            ++this.bindingsPrinted;
        }
        for (Map.Entry<Long, PersistentAddressBindingEncoding> entry : this.queueBindings.entrySet()) {
            QueueConfiguration queueConfig = this.queueBindings.get(entry.getKey()).getQueueConfiguration();
            this.xmlWriter.writeEmptyElement("queue-binding");
            this.xmlWriter.writeAttribute("address", queueConfig.getAddress().toString());
            this.xmlWriter.writeAttribute("filter-string", queueConfig.getFilterString() == null ? "" : queueConfig.getFilterString().toString());
            this.xmlWriter.writeAttribute("name", queueConfig.getName().toString());
            this.xmlWriter.writeAttribute("id", Long.toString(queueConfig.getId()));
            this.xmlWriter.writeAttribute("routing-type", queueConfig.getRoutingType().toString());
            ++this.bindingsPrinted;
        }
        this.xmlWriter.writeEndElement();
    }

    private void printAllMessagesAsXML() throws Exception {
        this.xmlWriter.writeStartElement("messages");
        if (this.logInterval > 0) {
            this.getActionContext().err.println("Processing journal messages");
        }
        long msgs = 0L;
        for (Map.Entry<Long, Message> messageMapEntry : this.messages.entrySet()) {
            this.printSingleMessageAsXML(messageMapEntry.getValue().toCore(), this.extractQueueNames(this.messageRefs.get(messageMapEntry.getKey())));
            if (this.logInterval <= 0 || ++msgs % (long)this.logInterval != 0L) continue;
            this.getActionContext().err.println("exported " + msgs + " messages from journal");
        }
        this.printPagedMessagesAsXML();
        this.xmlWriter.writeEndElement();
    }

    private void printSingleMessageAsXML(ICoreMessage message, List<String> queues) throws Exception {
        this.exporter.printSingleMessageAsXML(message, queues, false);
        ++this.messagesPrinted;
    }

    private void printPagedMessagesAsXML() {
        try {
            SimpleString[] stores;
            this.pagingmanager.start();
            long msgs = 0L;
            for (SimpleString store : stores = this.pagingmanager.getStoreNames()) {
                PagingStore pageStore = this.pagingmanager.getPageStore(store);
                if (pageStore != null) {
                    File folder = pageStore.getFolder();
                    logger.debug("Reading page store {} folder = {}", (Object)store, (Object)folder);
                    long pageId = pageStore.getFirstPage();
                    for (long i = 0L; i < pageStore.getNumberOfPages(); ++i) {
                        logger.debug("Reading page {}", (Object)pageId);
                        Page page = pageStore.newPageObject(pageId);
                        page.open(false);
                        LinkedList messages = page.read((StorageManager)this.storageManager);
                        page.close(false, false);
                        int messageId = 0;
                        try (LinkedListIterator iter = messages.iterator();){
                            while (iter.hasNext()) {
                                if (this.logInterval > 0 && ++msgs % (long)this.logInterval == 0L) {
                                    this.getActionContext().err.println("Exported " + msgs + " messages from paging");
                                }
                                PagedMessage message = (PagedMessage)iter.next();
                                message.initMessage((StorageManager)this.storageManager);
                                long[] queueIDs = message.getQueueIDs();
                                ArrayList<String> queueNames = new ArrayList<String>();
                                for (long queueID : queueIDs) {
                                    PersistentQueueBindingEncoding queueBinding;
                                    PagePositionImpl posCheck = new PagePositionImpl(pageId, messageId);
                                    boolean acked = false;
                                    Set<PagePosition> positions = this.cursorRecords.get(queueID);
                                    if (positions != null) {
                                        acked = positions.contains(posCheck);
                                    }
                                    if (acked || (queueBinding = this.queueBindings.get(queueID)) == null) continue;
                                    SimpleString queueName = queueBinding.getQueueConfiguration().getName();
                                    queueNames.add(queueName.toString());
                                }
                                if (!queueNames.isEmpty() && (message.getTransactionID() == -1L || this.pgTXs.contains(message.getTransactionID()))) {
                                    this.printSingleMessageAsXML(message.getMessage().toCore(), queueNames);
                                }
                                ++messageId;
                            }
                            ++pageId;
                            continue;
                        }
                    }
                    continue;
                }
                logger.debug("Page store was null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> extractQueueNames(Map<Long, DescribeJournal.ReferenceDescribe> refMap) {
        ArrayList<String> queues = new ArrayList<String>();
        for (DescribeJournal.ReferenceDescribe ref : refMap.values()) {
            String queueName;
            long id = ref.refEncoding.queueID;
            PersistentQueueBindingEncoding persistentQueueBindingEncoding = this.queueBindings.get(id);
            if (persistentQueueBindingEncoding == null) {
                String name = this.undefinedPrefix + id;
                this.queueBindings.put(id, new PersistentQueueBindingEncoding(QueueConfiguration.of((String)name).setAddress(name)));
                queueName = String.valueOf(name);
                this.getActionContext().err.println("Queue ID " + id + " not defined. Exporting it as " + name);
            } else {
                queueName = String.valueOf(persistentQueueBindingEncoding.getQueueConfiguration().getName());
            }
            queues.add(queueName);
        }
        return queues;
    }

    public static class PrettyPrintHandler
    implements InvocationHandler {
        private final XMLStreamWriter target;
        private int depth = 0;
        private static final char INDENT_CHAR = ' ';
        private static final String LINE_SEPARATOR = System.lineSeparator();
        boolean wrap = true;

        public PrettyPrintHandler(XMLStreamWriter target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String m;
            switch (m = method.getName()) {
                case "writeStartElement": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    ++this.depth;
                    break;
                }
                case "writeEndElement": {
                    --this.depth;
                    if (this.wrap) {
                        this.target.writeCharacters(LINE_SEPARATOR);
                        this.target.writeCharacters(this.indent(this.depth));
                    }
                    this.wrap = true;
                    break;
                }
                case "writeEmptyElement": 
                case "writeCData": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    break;
                }
                case "writeCharacters": {
                    this.wrap = false;
                }
            }
            method.invoke((Object)this.target, args);
            return null;
        }

        private String indent(int depth) {
            char[] output = new char[depth *= 3];
            while (depth-- > 0) {
                output[depth] = 32;
            }
            return new String(output);
        }
    }
}

